# -*- coding: utf-8 -*-
# @Time    : 10/12/2024 20.05
# @Author  : ljc
# @FileName: uly_fit_init.py
# @Software: PyCharm


# 1. 简介
"""
 Python conversion of the IDL uly_fit_init.pro .
目的:
    调用拟合各组件的初始化函数.
函数:
    1) uly_fit_init
解释:
    1) uly_fit_init 函数: 初始化包括可以在开始时执行一次的操作, 以在 "参数推断" 时节省计算.
    例如, 初始化可能包括读取文件、重采样模型网格等观测数据.
    uly_fit_init 必须在读取观测数据之后 (因为它需要知道采样和波长范围) 但在执行拟合程序 uly_fit 之前调用.
"""


# 2. 导库
import numpy as np
from uly_tgm.uly_tgm_init import uly_tgm_init
import warnings
warnings.filterwarnings("ignore")


# 3. 初始化函数
def uly_fit_init(cmp, lamrange=None, velscale=None, noredo=None) -> tuple[int, dict]:

    """
      调用拟合各组件的初始化函数, 其实这段代码意义不大, 因为 uly_tgm_init 函数已经初始化 cmp 了.

      输入参数:
      -----------
      cmp:
         为字典格式. 存储 TGM、待测参数初始值、勒让德多项式默认值等信息.
         cmp 是 1 个字典而不是字典列表, 因此 cmp 的长度记为 1.
      lamrange:
               波长范围, 单位为埃.
      velscale:
               像素大小, 单位为 km/s.

      输出参数:
      -----------
      status:
            0 表示成功完成.
      cmp:
         更新后的 cmp 字典.
    """

    # 3.1 获取波长信息
    wr = np.array(lamrange)
    
    # 3.2 初始化 cmp (如果 cmp 没有经过 uly_tgm_init 初始化)
    if cmp["init_fun"] == "":
        # 3.2.1 初始化 cmp
        cmp["start"] = np.log(wr[0])
        # 3.2.2 计算采样步长
        cmp["step"] = velscale / 299792.458
        # 3.2.3 计算像素数
        cmp["npix"] = 1 + int(np.round(np.log(wr[1] / wr[0]) / cmp["step"]))
        # cmp["npix"] = 1 + np.floor(np.log(wr[1] / wr[0]) / cmp["step"])
        # 3.2.4 采样方式
        cmp["sampling"] = 1
        # 3.2.5 评估数据
        cmp["eval_data"] = cmp
    else:
        # 3.2.6 初始化 cmp
        cmp = uly_tgm_init(cmp, LAMOST_lamrange=wr, velscale=velscale)
        status = 0

    # 3.3 返回初始化状态、以及 cmp
    return status, cmp