# -*- coding: utf-8 -*-
# @Time    : 2025/1/28 11:26
# @Author  : ljc
# @FileName: setup.py
# @Software: PyCharm


# 1. 简介
"""
目的:
    安装 LASP 包.
解释:
    1) 安装依赖库.
    2) 安装 LASP 包.
    3) 在 LASP 目录创建虚拟环境, 打开该虚拟环境后, 输入 "pip install -e ." 安装 LASP 包.
"""


# 2. 导库
from setuptools import setup, find_packages
import sys

# 3. 检查Python版本
if sys.version_info < (3, 9):
    sys.exit('需要Python 3.9 或更高版本!')

# 4. 定义依赖项
install_requires = ['numpy==1.26.4',
                    'pandas==2.2.3',
                    'astropy==6.0.1',
                    'scipy==1.13.1',  # 包含curve_fit
                    'matplotlib==3.9.4',
                    'tqdm==4.67.1',
                    'joblib==1.4.2',
                    'filelock==3.18.0',
                    # 'torch==2.5.0',  # PyTorch版本, 注意默认安装 CPU 版本, 如果需要安装 GPU 版本, 请查询 PyTorch 官网
                                       # GPU 版本安装命令, 如: pip install torch==2.5.0 torchvision==0.20.0 torchaudio==2.5.0 --index-url https://download.pytorch.org/whl/cu121
                    ]

# 5. 安装 LASP 包
setup(name="LASP",
      version="0.1",
      packages=find_packages(),
      package_dir={'': '.'},
      install_requires=install_requires,
      python_requires='>=3.9',
      )