# -*- coding: utf-8 -*-
# @Time    : 2025/1/28 11:26
# @Author  : ljc
# @FileName: file_paths.py
# @Software: PyCharm


# 1. 简介
"""
目的:
    指定 LASP 根目录路径.
函数:
    1) TGM_MODEL_FILE
    2) TEST_DATA_DIR
    3) LASP_ROOT
解释:
    1) TGM_MODEL_FILE: 指定 "TGM 模型" 文件路径, 便于调用 elodie32_flux_tgm.fits 文件.
    2) TEST_DATA_DIR: 指定 "test_data" 目录路径, 便于调用 test_data 目录下的数据.
    3) LASP_ROOT: 指定 LASP 根目录路径, 便于调用 LASP 根目录下的文件.
"""


# 2. 导库
import os

# 3. 定义 LASP 根目录路径
LASP_ROOT_PATH = os.path.dirname(os.path.abspath(__file__))

# 4. 定义常用文件路径
def TGM_MODEL_FILE() -> str:
    file =os.path.join(LASP_ROOT_PATH, 'tgm_model/elodie32_flux_tgm.fits').replace('\\', '/')
    return file

# 5. 定义 test_data 目录路径
def TEST_DATA_DIR() -> str:
    file = os.path.join(LASP_ROOT_PATH, 'test_data/').replace('\\', '/')
    return file

# 6. 定义 LASP 根目录路径
def LASP_ROOT() -> str:
    file = os.path.join(LASP_ROOT_PATH, '').replace('\\', '/')
    return file