from ctypes import POINTER, Structure, c_char, c_double, c_int

from define import MAX_CHAR, MAXFLAG, MAXNAPER


class Prefs2(Structure):
  _alignment_ = 16

Prefs2._fields_ = [
  ("naper", c_int),
  ("detect_type", c_int),
  ("mask_type", c_int),
  ("apert", c_double * MAXNAPER),
  ("flux_apersize", c_int),
  ("fluxerr_apersize", c_int),
  ("mag_apersize", c_int),
  ("magerr_apersize", c_int),
  ("mag_zeropoint", c_double),
  ("autoaper", c_double * 2),
  ("autoparam", c_double * 2),
  ("growth_flag", c_int),
  ("seeing_fwhm", c_double),
  ("world_flag", c_int),
]