from ctypes import Structure, c_double, c_float, c_int, c_short

from define import NAPER


class OutobjStruct(Structure):
  _alignment_ = 16
  _pack_ = 16

OutobjStruct._fields_ = [
  ("number", c_int),
  ("alpha2000", c_double),
  ("delta2000", c_double),
  ("sposx", c_float),
  ("sposy", c_float),
  ("flux_iso", c_float),
  ("fluxerr_iso", c_float),
  ("mag_iso", c_float),
  ("magerr_iso", c_float),
  ("flux_isocor", c_float),
  ("fluxerr_isocor", c_float),

  ("flux_aper", c_float * NAPER),
  ("fluxerr_aper", c_float * NAPER),
  ("mag_aper", c_float * NAPER),
  ("magerr_aper", c_float * NAPER),

  ("flux_auto", c_float),
  ("fluxerr_auto", c_float),
  ("mag_auto", c_float),
  ("magerr_auto", c_float),
  ("theta", c_float),

  ("poserr_mx2", c_double),  # ERRX2_IMAGE
  ("poserr_my2", c_double),  # ERRY2_IMAGE
  ("poserr_mxy", c_double),  # ERRXY_IMAGE

  ("flag", c_short, 16),         # FLAGS
  ("elong", c_float),        # ELONGATION
  ("ellip", c_float),        # ELLIPTICITY
  ("sprob", c_float),        # CLASS_STAR
  ("peak", c_float),         # FLUX_MAX
  ("kronfactor", c_float),   # KRON_RADIUS
  ("bkg", c_float),          # BACKGROUND
  ("fwhm", c_float),         # FWHM_IMAGE
]