import yaml
from .define import MAXNAPER


class Prefs():
  shape = 4096
  width = 4096
  height = 4096

  naper = 1
  mask_type = 2
  flux_apersize = 0
  flux_err_apersize = 0
  mag_apersize = 0
  mag_zeropoint = 0.0
  autoaper = [0.0, 0.0]
  autoparam = [2.5, 3.5]
  growth_flag = 0
  seeing_fwhm = 1.2
  world_flag = 0

  backsize = [64, 64]
  backfsize = [3, 3]
  backfthresh = 0.0
  ndthresh = 1
  nthresh = 1
  thresh_type = [0, 0]  # 0 THRESH_RELATIVE 1 THRESH_ABSOLUTE
  dthresh = [3, 0]
  thresh = [3, 0]
  ext_minarea = 15
  # deblend
  deblend_nthresh = 35
  deb_maxarea = 3
  deblend_mincount = 0.005
  # photometry
  mag_gamma = 4.0
  gain = 0.0
  satur_level = 50000.0
  # weighting
  weightgain_flag = 1
  # cleaning
  clean_flag = 1
  clean_param = 1.0
  # extraction
  detect_type = 0  # enum {CCD, PHOTO} 0 1
  # memory
  clean_stacksize = 3000

  apert = [0.0 for i in range(MAXNAPER)]
  apert[0] = 10.0

  def __init__(self, prefs_file_path=None):
    if prefs_file_path is not None:
      self.load_prefs(prefs_file_path)

  def load_prefs(self, prefs_file_path):
    prefs = None
    with open(prefs_file_path, 'r') as f:
      prefs = yaml.load(f, Loader=yaml.FullLoader)
    self.__dict__.update(prefs)
  

  def build_endobject_param(self):
    return {
      "prefs_naper": self.naper,
      "prefs_mask_type": self.mask_type,
      "prefs_apert": self.apert,
      "prefs_flux_apersize": self.flux_apersize,
      "prefs_flux_err_apersize": self.flux_err_apersize,
      "prefs_mag_apersize": self.mag_apersize,
      "prefs_mag_zeropoint": self.mag_zeropoint,
      "prefs_auto_aper": self.autoaper,
      "prefs_auto_param": self.autoparam,
      "prefs_growth_flag": self.growth_flag,
      "prefs_seeing_fwhm": self.seeing_fwhm,
      "prefs_world_flag": self.world_flag
    }
