from .define import NAPER, NAXIS


class Obj2Struct():

  def __init__(self):
    self.mag_iso = 0.0
    self.magerr_iso = 0.0
    self.poserr_a = 0.0
    self.poserr_cxx = 0.0
    self.elong = 0.0
    self.ellip = 0.0
    self.polar = 0.0
    self.flux_isocor = 0.0
    self.flux_auto = 1.40129846e-45
    self.flux_petro = 0.0
    self.sprob = 1.40129846e-45
    self.mag_auto = 1.40129846e-45
    self.magerr_auto = 0.0
    self.flux_aper = [0.0] * NAPER
    self.alpha2000 = 0.0
    self.mxw = 0.0

  def build_func_params():
    pass

  def build_endobject_param(self):
    return {
      "obj2_mag_iso": self.mag_iso,
      "obj2_magerr_iso": self.magerr_iso,
      "obj2_poserr_a": self.poserr_a,
      "obj2_poserr_cxx": self.poserr_cxx,
      "obj2_elong": self.elong,
      "obj2_ellip": self.ellip,
      "obj2_polar": self.polar,
      "obj2_flux_isocor": self.flux_isocor,
      "obj2_flux_auto": self.flux_auto,
      "obj2_flux_petro": self.flux_petro,
      "obj2_sprob": self.sprob,
      "obj2_mag_auto": self.mag_auto,
      "obj2_magerr_auto": self.magerr_auto,
      "obj2_flux_aper": self.flux_aper,
      "obj2_alpha2000": self.alpha2000,
      "obj2_mxw": self.mxw
    }