from ctypes import POINTER, Structure, c_double, c_float, c_int, c_short

from define import NAPER, NAXIS


class Obj2Struct(Structure):
  _alignment_ = 16

  def __init__(self):
    self.mag_iso = 0.0
    self.magerr_iso = 0.0
    self.poserr_a = 0.0
    self.poserr_cxx = 0.0
    self.elong = 0.0
    self.ellip = 0.0
    self.polar = 0.0
    self.flux_isocor = 0.0
    self.flux_auto = 1.40129846e-45
    self.flux_petro = 0.0
    self.sprob = 1.40129846e-45
    self.mag_auto = 1.40129846e-45
    self.magerr_auto = 0.0
    self.flux_aper[0] = 0.0
    self.alpha2000 = 0.0
    self.mxw = 0.0

Obj2Struct._fields_ = [
  ("flux_iso", c_float),
  ("fluxerr_iso", c_float),
  ("mag_iso", c_float),
  ("magerr_iso", c_float),
  ("flux_isocor", c_float),
  ("fluxerr_isocor", c_float),
  ("mag_isocor", c_float),
  ("magerr_isocor", c_float),
  ("kronfactor", c_float),
  ("flux_auto", c_float),
  ("fluxerr_auto", c_float),
  ("mag_auto", c_float),
  ("magerr_auto", c_float),
  ("petrofactor", c_float),
  ("flux_petro", c_float),
  ("fluxerr_petro", c_float),
  ("mag_petro", c_float),
  ("magerr_petro", c_float),
  ("flux_best", c_float),
  ("fluxerr_best", c_float),
  ("mag_best", c_float),
  ("magerr_best", c_float),
  ("flux_aper", c_float * NAPER),
  ("fluxerr_aper", c_float * NAPER),
  ("mag_aper", c_float * NAPER),
  ("magerr_aper", c_float * NAPER),
  ("flux_win", c_float),
  ("fluxerr_win", c_float),
  ("mag_win", c_float),
  ("magerr_win", c_float),
  ("posx", c_double),
  ("posy", c_double),
  ("jacob", c_double * (NAXIS * NAXIS)),
  ("mamaposx", c_double),
  ("mamaposy", c_double),
  ("sposx", c_float),
  ("sposy", c_float),
  ("poserr_a", c_float),
  ("poserr_b", c_float),
  ("poserr_theta", c_float),
  ("poserr_cxx", c_float),
  ("poserr_cyy", c_float),
  ("poserr_cxy", c_float),
  ("poserr_mx2w", c_double),
  ("poserr_my2w", c_double),
  ("poserr_mxyw", c_double),
  ("poserr_aw", c_float),
  ("poserr_bw", c_float),
  ("poserr_thetaw", c_float),
  ("poserr_thetas", c_float),
  ("poserr_theta2000", c_float),
  ("poserr_theta1950", c_float),
  ("poserr_cxxw", c_float),
  ("poserr_cyyw", c_float),
  ("poserr_cxyw", c_float),
  ("mx2w", c_double),
  ("my2w", c_double),
  ("mxyw", c_double),
  ("peakxw", c_double),
  ("peakyw", c_double),
  ("mxw", c_double),
  ("myw", c_double),
  ("alphas", c_double),
  ("deltas", c_double),
  ("thetas", c_float),
  ("peakalphas", c_double),
  ("peakdeltas", c_double),
  ("peakalpha2000", c_double),
  ("peakdelta2000", c_double),
  ("peakalpha1950", c_double),
  ("peakdelta1950", c_double),
  ("alpha2000", c_double),
  ("delta2000", c_double),
  ("theta2000", c_float),
  ("dtheta2000", c_double),
  ("alpha1950", c_double),
  ("delta1950", c_double),
  ("theta1950", c_float),
  ("dtheta1950", c_double),
  ("aw", c_float),
  ("bw", c_float),
  ("thetaw", c_float),
  ("cxxw", c_float),
  ("cyyw", c_float),
  ("cxyw", c_float),
  ("npixw", c_float),
  ("fdnpixw", c_float),
  ("threshmu", c_float),
  ("maxmu", c_float),
  ("elong", c_float),
  ("ellip", c_float),
  ("polar", c_float),
  ("polarw", c_float),
  ("sprob", c_float),
  ("fwhmw", c_float),
  ("assoc", POINTER(c_float)),
  ("assoc_number", c_int),
  ("vignet", POINTER(c_float)),
  ("vigshift", POINTER(c_float)),
  ("ext_number", c_short)
]