from ctypes import POINTER, Structure, c_byte, c_double, c_float, c_int, c_short, c_ubyte
from re import M

from define import MAXFLAG, NISO


class ObjStruct(Structure):
  pass

ObjStruct._fields_ = [
  # basic parameters
  ("number", c_int),
  ("fdnpix", c_int),
  ("dnpix", c_int),
  ("npix", c_int),
  ("fdflux", c_float),
  ("dflux", c_float),
  ("flux", c_float),
  ("fluxerr", c_float),
  ("fdpeak", c_float), # PIXTYPE
  ("dpeak", c_float), # PIXTYPE
  ("peak", c_float), # PIXTYPE
  # astrometric data
  ("peakx", c_int),
  ("peaky", c_int),
  ("mx", c_double),
  ("my", c_double),
  ("poserr_mx2", c_double),
  ("poserr_my2", c_double),
  ("poserr_mxy", c_double),
  ("xmin", c_int),
  ("xmax", c_int),
  ("ymin", c_int),
  ("ymax", c_int),
  ("ycmin", c_int),
  ("ycmax", c_int),
  ("blank", POINTER(c_float)),
  ("dblank", POINTER(c_float)),
  ("submap", POINTER(c_int)),
  ("subx", c_int),
  ("suby", c_int),
  ("subw", c_int),
  ("subh", c_int),
  ("flag", c_short),
  ("wflag", c_ubyte),
  ("imageflag", c_int * MAXFLAG),
  ("mx2", c_double),
  ("my2", c_double),
  ("mxy", c_double),
  ("a", c_float),
  ("b", c_float),
  ("theta", c_float),
  ("abcor", c_float),
  ("cxx", c_float),
  ("cyy", c_float),
  ("cxy", c_float),
  ("firstpix", c_int),
  ("lastpix", c_int),
  ("bkg", c_float),
  ("dbkg", c_float),
  ("sigbkg", c_float),
  ("thresh", c_float),
  ("dthresh", c_float),
  ("mthresh", c_float),
  ("iso", c_int * NISO),
  ("fwhm", c_float),
]