

from Function.align_pipe.align import align_points_pipe
from Function.detection_pipe.detection import source_detection_function
from Function.sub_pipe.sub import sub_function
import nvidia.dali.fn as fn
import os
import sys
current_dir = os.path.dirname(os.path.abspath(__file__))
grandparent_dir = os.path.abspath(os.path.join(current_dir, "../../../"))
sys.path.append(grandparent_dir)
print(grandparent_dir)
import AIPT
import cupy as cp
import numpy as np      

def align_function(i_crpix, i_cd_matrix, i_crval, i_a_coeffs, i_b_coeffs, t_crpix, t_cd_matrix, t_crval, t_ap_coeffs, t_bp_coeffs, data_source, step=10, device='gpu'):
        return fn.python_function(i_crpix, i_cd_matrix, i_crval, i_a_coeffs, i_b_coeffs, t_crpix, t_cd_matrix, t_crval, t_ap_coeffs, t_bp_coeffs, data_source, step, function=align_points_pipe, num_outputs=1, device= device)

def get_background_function(data, box_size=(64,64), filter_size= (3,3), device='gpu'):
        return fn.python_function(data, box_size,filter_size,function=AIPT.get_background_g, num_outputs=1, device=device)

def Power_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Power_g, num_outputs=1, device= device)

def Linear_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Linear_g, num_outputs=1, device= device)

def Log_function(data, vmin, vmax, device='gpu'):
        return fn.python_function(data, vmin, vmax,function=AIPT.Log_g, num_outputs=1, device= device)

def Sinh_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Sinh_g, num_outputs=1, device= device)

def Asinh_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Asinh_g, num_outputs=1, device= device)

def HistEq_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.HistEq_g, num_outputs=1, device= device)

def Bytescale_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Bytescale_g, num_outputs=1, device= device)

def Bytescale_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.Bytescale_g, num_outputs=1, device= device)

def get_limits_percentile_function(data,vmin, vmax, device='gpu'):
        return fn.python_function(data,vmin, vmax , function=AIPT.get_limits_percentile_g, num_outputs=2, device= device)

def get_limits_zscale_function(data, device='gpu'):
        return fn.python_function(data, function=AIPT.get_limits_zscale_g, num_outputs=2, device= device)