# Background Esitmation
from ctypes import CDLL, POINTER, c_float, c_int

from prefs import Prefs
from structs.pic_struct import PicStruct

def back_esitmate_py(field: PicStruct, lib: CDLL, prefs: Prefs):
  backmean = c_float(field.backmean)
  backsig = c_float(field.backsig)

  lib.back_estimate.argtypes = [c_int, c_float, POINTER(c_float), POINTER(c_float), c_int, c_int, c_int]
  lib.back_estimate(field.backw, prefs.backfthresh, backmean, backsig, field.nbackfx, field.nbackfy, 0)
  field.backmean = backmean
  field.backsig = backsig
  print("backmean: ", field.backmean)
  print("backsig: ", field.backsig)

  if field.back_type == 1: # 1 BACK_ABSOLUTE
    pass
  if prefs.ndthresh > 1:
    pass
  elif prefs.thresh_type[0] == 1: # 1 THRESH_ABSOLUTE
    field.dthresh = c_float(prefs.dthresh[0])
  else:
    field.dthresh = c_float(prefs.dthresh[0] * field.backsig)
  # print(field.dthresh)

  if prefs.nthresh > 1:
    pass
  elif prefs.thresh_type[1] == 1: # 1 THRESH_ABSOLUTE
    field.thresh = c_float(prefs.thresh_type[0])
  else:
    field.thresh = c_float(prefs.thresh[0] * field.backsig)