from define import MAXNAPER
import yaml

class Prefs():
  naper = 1
  mask_type = 2
  flux_apersize = 0
  flux_err_apersize = 0
  mag_apersize = 0
  mag_zeropoint = 0.0
  autoaper = [0.0, 0.0]
  autoparam = [2.5, 3.5]
  growth_flag = 0
  seeing_fwhm = 1.2
  world_flag = 0

  backsize = [64, 64]
  backfsize = [3, 3]
  backfthresh = 0.0
  ndthresh = 1
  nthresh = 1
  thresh_type = [0, 0] # 0 THRESH_RELATIVE 1 THRESH_ABSOLUTE
  dthresh = [5, 0]
  thresh = [5, 0]
  ext_minarea = 30
  # deblend
  deblend_nthresh = 30
  deb_maxarea = 3
  deblend_mincount = 0.005
  # photometry
  mag_gamma = 4.0
  gain = 0.0
  satur_level = 50000.0
  # weighting
  weightgain_flag = 1
  # cleaning
  clean_flag = 1
  clean_param = 1.0
  # extraction
  detect_type = 0 # enum {CCD, PHOTO} 0 1
  # memory
  clean_stacksize = 3000

  apert = [0.0 for i in range(MAXNAPER)]
  apert[0] = 10.0


  def __init__(self, prefs_file_path=None):
    if prefs_file_path is not None:
      self.load_prefs(prefs_file_path)

  def load_prefs(self, prefs_file_path):
    prefs = None
    with open(prefs_file_path, 'r') as f:
      prefs = yaml.load(f, Loader=yaml.FullLoader)
    self.__dict__.update(prefs)