from ctypes import c_float, c_long
from math import log
from numpy import ndarray
from prefs import Prefs
from structs.pic_struct import PicStruct


def PicStructInit(image_data: ndarray, prefs: Prefs):
  pic = PicStruct(backmean = 0, backsig = 0)
  # pic.backmean = 0
  # pic.backsig = 0
  # maybe change by next develop
  pic.back_type = 0 # 0 BACK_RELATIVE 1 BACK_ABSOLUTE

  pic.width = image_data.shape[0]
  pic.height = image_data.shape[1]
  pic.ymax = pic.height
  pic.ymin = 0
  pic.backw = prefs.backsize[0] if prefs.backsize[0] < pic.width else pic.width
  pic.backh = prefs.backsize[1] if prefs.backsize[1] < pic.height else pic.height
  pic.backp = pic.backw * pic.backh

  pic.nbackx = 1 if ((pic.width - 1) / pic.backw + 1) < 1 else int(((pic.width - 1) / pic.backw + 1))
  pic.nbacky = 1 if ((pic.height - 1) / pic.backh + 1) < 1 else int(((pic.height - 1) / pic.backh + 1))

  pic.nbackfx =  prefs.backfsize[0] if pic.nbackx > 1 else 1;
  pic.nbackfy =  prefs.backfsize[1] if pic.nbacky > 1 else 1;

  pic.ngamma = prefs.mag_gamma / log(10.0)

  pic.gain = prefs.gain
  pic.satur_level = prefs.satur_level

  return pic