from typing_extensions import Self
from math import log

from py_params.prefs import Prefs


class PicStruct:
  backw = 0
  backh = 0
  backp = 0
  nbackfx = 0
  nbackfy = 0
  backmean = 0.0
  backsig = 0.0
  d_mean = []
  d_sig = []
  dthresh = 0.0
  thresh = 0.0
  back_type = 0
  width = 0
  height = 0
  nbackx = 0
  nbacky = 0
  ngamma = 0.0
  gain = 0.0
  satur_level = 0.0

  def __init__(self, prefs: Prefs) -> Self:
    self.width = prefs.width
    self.height = prefs.height
    self.ymax = self.height
    self.ymin = 0
    self.back_type = 0  # 0 BACK_RELATIVE 1 BACK_ABSOLUTE
    self.backw = prefs.backsize[0] if prefs.backsize[0] < self.width else self.width
    self.backh = prefs.backsize[1] if prefs.backsize[1] < self.height else self.height
    self.backp = self.backw * self.backh
    self.nbackx = 1 if ((self.width - 1) / self.backw + 1) < 1 else int(
        ((self.width - 1) / self.backw + 1))
    self.nbacky = 1 if ((self.height - 1) / self.backh + 1) < 1 else int(
        ((self.height - 1) / self.backh + 1))

    self.nbackfx = prefs.backfsize[0] if self.nbackx > 1 else 1
    self.nbackfy = prefs.backfsize[1] if self.nbacky > 1 else 1

    self.ngamma = prefs.mag_gamma / log(10.0)

    self.gain = prefs.gain
    self.satur_level = prefs.satur_level