// Copyright 2022 HE Boliang
// All rights reserved.

package gofa_test

import (
	"testing"

	"github.com/hebl/gofa"
)

func TestFk425(t *testing.T) {
	var r1950, d1950, dr1950, dd1950, p1950, v1950, r2000, d2000, dr2000, dd2000, p2000, v2000 float64

	r1950 = 0.07626899753879587532
	d1950 = -1.137405378399605780
	dr1950 = 0.1973749217849087460e-4
	dd1950 = 0.5659714913272723189e-5
	p1950 = 0.134
	v1950 = 8.7

	gofa.Fk425(r1950, d1950, dr1950, dd1950, p1950, v1950, &r2000, &d2000, &dr2000, &dd2000, &p2000, &v2000)

	vvd(t, r2000, 0.08757989933556446040, 1e-14, "Fk425", "r2000")
	vvd(t, d2000, -1.132279113042091895, 1e-12, "Fk425", "d2000")
	vvd(t, dr2000, 0.1953670614474396139e-4, 1e-17, "Fk425", "dr2000")
	vvd(t, dd2000, 0.5637686678659640164e-5, 1e-18, "Fk425", "dd2000")
	vvd(t, p2000, 0.1339919950582767871, 1e-13, "Fk425", "p2000")
	vvd(t, v2000, 8.736999669183529069, 1e-12, "Fk425", "v2000")
}

func TestFk45z(t *testing.T) {
	var r1950, d1950, bepoch, r2000, d2000 float64

	r1950 = 0.01602284975382960982
	d1950 = -0.1164347929099906024
	bepoch = 1954.677617625256806

	gofa.Fk45z(r1950, d1950, bepoch, &r2000, &d2000)

	vvd(t, r2000, 0.02719295911606862303, 1e-15, "Fk45z", "r2000")
	vvd(t, d2000, -0.1115766001565926892, 1e-13, "Fk45z", "d2000")
}

func TestFk524(t *testing.T) {
	var r2000, d2000, dr2000, dd2000, p2000, v2000, r1950, d1950, dr1950, dd1950, p1950, v1950 float64

	r2000 = 0.8723503576487275595
	d2000 = -0.7517076365138887672
	dr2000 = 0.2019447755430472323e-4
	dd2000 = 0.3541563940505160433e-5
	p2000 = 0.1559
	v2000 = 86.87

	gofa.Fk524(r2000, d2000, dr2000, dd2000, p2000, v2000, &r1950, &d1950, &dr1950, &dd1950, &p1950, &v1950)

	vvd(t, r1950, 0.8636359659799603487, 1e-13, "Fk524", "r1950")
	vvd(t, d1950, -0.7550281733160843059, 1e-13, "Fk524", "d1950")
	vvd(t, dr1950, 0.2023628192747172486e-4, 1e-17, "Fk524", "dr1950")
	vvd(t, dd1950, 0.3624459754935334718e-5, 1e-18, "Fk524", "dd1950")
	vvd(t, p1950, 0.1560079963299390241, 1e-13, "Fk524", "p1950")
	vvd(t, v1950, 86.79606353469163751, 1e-11, "Fk524", "v1950")
}

func TestFk52h(t *testing.T) {
	var r5, d5, dr5, dd5, px5, rv5, rh, dh, drh, ddh, pxh, rvh float64

	r5 = 1.76779433
	d5 = -0.2917517103
	dr5 = -1.91851572e-7
	dd5 = -5.8468475e-6
	px5 = 0.379210
	rv5 = -7.6

	gofa.Fk52h(r5, d5, dr5, dd5, px5, rv5, &rh, &dh, &drh, &ddh, &pxh, &rvh)

	vvd(t, rh, 1.767794226299947632, 1e-14, "Fk52h", "ra")
	vvd(t, dh, -0.2917516070530391757, 1e-14, "Fk52h", "dec")
	vvd(t, drh, -0.1961874125605721270e-6, 1e-19, "Fk52h", "dr5")
	vvd(t, ddh, -0.58459905176693911e-5, 1e-19, "Fk52h", "dd5")
	vvd(t, pxh, 0.37921, 1e-14, "Fk52h", "px")
	vvd(t, rvh, -7.6000000940000254, 1e-11, "Fk52h", "rv")
}

func TestFk54z(t *testing.T) {
	var r2000, d2000, bepoch, r1950, d1950, dr1950, dd1950 float64

	r2000 = 0.02719026625066316119
	d2000 = -0.1115815170738754813
	bepoch = 1954.677308160316374

	gofa.Fk54z(r2000, d2000, bepoch, &r1950, &d1950, &dr1950, &dd1950)

	vvd(t, r1950, 0.01602015588390065476, 1e-14, "Fk54z", "r1950")
	vvd(t, d1950, -0.1164397101110765346, 1e-13, "Fk54z", "d1950")
	vvd(t, dr1950, -0.1175712648471090704e-7, 1e-20, "Fk54z", "dr1950")
	vvd(t, dd1950, 0.2108109051316431056e-7, 1e-20, "Fk54z", "dd1950")
}

func TestFk5hip(t *testing.T) {
	var r5h [3][3]float64
	var s5h [3]float64

	gofa.Fk5hip(&r5h, &s5h)

	vvd(t, r5h[0][0], 0.9999999999999928638, 1e-14, "Fk5hip", "11")
	vvd(t, r5h[0][1], 0.1110223351022919694e-6, 1e-17, "Fk5hip", "12")
	vvd(t, r5h[0][2], 0.4411803962536558154e-7, 1e-17, "Fk5hip", "13")
	vvd(t, r5h[1][0], -0.1110223308458746430e-6, 1e-17, "Fk5hip", "21")
	vvd(t, r5h[1][1], 0.9999999999999891830, 1e-14, "Fk5hip", "22")
	vvd(t, r5h[1][2], -0.9647792498984142358e-7, 1e-17, "Fk5hip", "23")
	vvd(t, r5h[2][0], -0.4411805033656962252e-7, 1e-17, "Fk5hip", "31")
	vvd(t, r5h[2][1], 0.9647792009175314354e-7, 1e-17, "Fk5hip", "32")
	vvd(t, r5h[2][2], 0.9999999999999943728, 1e-14, "Fk5hip", "33")
	vvd(t, s5h[0], -0.1454441043328607981e-8, 1e-17, "Fk5hip", "s1")
	vvd(t, s5h[1], 0.2908882086657215962e-8, 1e-17, "Fk5hip", "s2")
	vvd(t, s5h[2], 0.3393695767766751955e-8, 1e-17, "Fk5hip", "s3")
}

func TestFk5hz(t *testing.T) {
	var r5, d5, rh, dh float64

	r5 = 1.76779433
	d5 = -0.2917517103

	gofa.Fk5hz(r5, d5, 2400000.5, 54479.0, &rh, &dh)

	vvd(t, rh, 1.767794191464423978, 1e-12, "Fk5hz", "ra")
	vvd(t, dh, -0.2917516001679884419, 1e-12, "Fk5hz", "dec")
}

func TestH2fk5(t *testing.T) {
	var rh, dh, drh, ddh, pxh, rvh, r5, d5, dr5, dd5, px5, rv5 float64

	rh = 1.767794352
	dh = -0.2917512594
	drh = -2.76413026e-6
	ddh = -5.92994449e-6
	pxh = 0.379210
	rvh = -7.6

	gofa.H2fk5(rh, dh, drh, ddh, pxh, rvh, &r5, &d5, &dr5, &dd5, &px5, &rv5)

	vvd(t, r5, 1.767794455700065506, 1e-13, "H2fk5", "ra")
	vvd(t, d5, -0.2917513626469638890, 1e-13, "H2fk5", "dec")
	vvd(t, dr5, -0.27597945024511204e-5, 1e-18, "H2fk5", "dr5")
	vvd(t, dd5, -0.59308014093262838e-5, 1e-18, "H2fk5", "dd5")
	vvd(t, px5, 0.37921, 1e-13, "H2fk5", "px")
	vvd(t, rv5, -7.6000001309071126, 1e-11, "H2fk5", "rv")
}

func TestHfk5z(t *testing.T) {
	var rh, dh, r5, d5, dr5, dd5 float64

	rh = 1.767794352
	dh = -0.2917512594

	gofa.Hfk5z(rh, dh, 2400000.5, 54479.0, &r5, &d5, &dr5, &dd5)

	vvd(t, r5, 1.767794490535581026, 1e-13, "Hfk5z", "ra")
	vvd(t, d5, -0.2917513695320114258, 1e-14, "Hfk5z", "dec")
	vvd(t, dr5, 0.4335890983539243029e-8, 1e-22, "Hfk5z", "dr5")
	vvd(t, dd5, -0.8569648841237745902e-9, 1e-23, "Hfk5z", "dd5")
}
