import numpy as np
import cv2
from skimage.transform import resize

def get_xy_flux(det, img):
    '''
    修正回归框的中心点和宽高！
    :param det:
    :param img:
    :return:
    '''
    # flux_thresh = 2
    x1 = det[:, 0].astype(np.int32)
    x2 = det[:, 2].astype(np.int32)
    y1 = det[:, 1].astype(np.int32)
    y2 = det[:, 3].astype(np.int32)
    flux_pre = []
    xy_point = []
    for i in range(len(det)):
        flux_pre.append(np.max(img[y1[i]:(y2[i]+1), x1[i]:(x2[i]+1)]))   # 将原图中框内最大的像素值作为flux值！
        index = np.argmax(img[y1[i]:(y2[i]+1), x1[i]:(x2[i]+1)])
        w = x2[i] - x1[i] + 1
        h = y2[i] - y1[i] + 1
        x0 = x1[i] + index % w
        y0 = y1[i] + index // w
        xy_point.append((x0, y0, w, h))
    # # 保证分母不为0！
    # if np.min(flux_pre):
    #     _flux_pre = (1 / np.min(flux_pre)) * flux_pre * flux_thresh  # 保证_flux_pre值都大于2
    # else:
    #     raise Exception('min(flux_pre) is 0!')
    return xy_point, flux_pre
    

def cal_initial_xy(xy_p, xy_p_new, flux_list, flag):
    '''
    计算原始的中心坐标，同时去除重复检测的目标
    :param xy_p:
    :param xy_p_new:
    :param flux_list:
    :param flag: 尺度大小的标志
    :return: 更新的检测结果
    '''
    xy_p = np.array(xy_p)
    flux_np = np.array(flux_list).reshape(-1, 1)
    if flag == 256:
        xy_p *= 16
    if flag == 512:
        xy_p *= 8
    xy_f = np.concatenate((xy_p, flux_np), axis=1).tolist()
    # 事先筛除一部分重复框(挨得很近的情况)——很有必要！
    if xy_p_new:
        for i in range(len(xy_p_new)):
            xy_f = list(
                filter(lambda x: (x[0] - xy_p_new[i][0]) ** 2 + (x[1] - xy_p_new[i][1]) ** 2 > (8*2) ** 2,
                       xy_f))
        xy_p_new.extend(xy_f)
    else:
        xy_p_new.extend(xy_f)
    # xy_p_new.extend(xy_f)   # 直接添加检测结果--不做筛除！
    return xy_p_new

    
    
# 产生模拟图像！更合理！
def data_generate(all_xy_point_list, psf_matrix, s, flag):
    
    def norm(img):
        img = (img - np.min(img)) / (np.max(img) - np.min(img))  # normalization
        return img

    mask = np.zeros((s * 2, s * 2))  # mask作为模板，用以提取目标，做目标分割！
    psf_max = np.max(resize(psf_matrix, (s, s), anti_aliasing=True))
    for point_flux in all_xy_point_list:
        point = point_flux[:4]
        flux = point_flux[-1]
        mask_tem = np.zeros((s * 2, s * 2))  # mask作为模板，用以提取目标，做目标分割！
        scale = int(flux / psf_max)  # 计算flux值与PSF的倍数
        psf_matrix_new = psf_matrix.copy()
        if scale:
            # 放缩用的是opencv 的resize函数，采用的是线性插值
            psf_matrix_new = cv2.resize(psf_matrix_new, (s * scale, s * scale))
            psf_matrix_new = psf_matrix_new[(len(psf_matrix_new) // 2 - s // 2):(len(psf_matrix_new) // 2 + s // 2),
                             (len(psf_matrix_new) // 2 - s // 2):(len(psf_matrix_new) // 2 + s // 2)]
        psf_matrix_new = norm(cv2.resize(psf_matrix_new, (s, s)))
        # psf_matrix_new = cv.resize(psf_matrix_new, (s, s))
        # 产生模拟图像！
        # Poisson分布 ; psf_matrix_new:256*256
        x_Poisson = np.random.poisson(lam=flux, size=(1, 1))  # lam为λ size为k
        if flag:
            # 若变为1，则需要将坐标扩大一倍
            mask_tem[int(point[1] // (4096 // s)):(int(point[1] // (4096 // s)) + s),
            int(point[0] // (4096 // s)):(int(point[0] // (4096 // s)) + s)] += x_Poisson[0][0] * psf_matrix_new
        else:
            mask_tem[int(point[1] // (4096 // s)):(int(point[1] // (4096 // s)) + s),
            int(point[0] // (4096 // s)):(int(point[0] // (4096 // s)) + s)] += x_Poisson[0][0] * psf_matrix_new * \
                                                                                x_Poisson[0][0]
        # 每个中心点处的目标进行叠加
        mask += mask_tem
    # 取限定大小的模拟图像
    point_matrix_simulate = mask[s // 2:s // 2 + s, s // 2:s // 2 + s]

    return point_matrix_simulate