from scipy import ndimage
import cv2
import numpy as np

def ultra_bright_source_det(img1, kernel_3, kernel_21, s):
    # erosion = cv2.erode(img1, kernel_3)
    # 卷积：使得图像更具具备psf特性
    filter_img = ndimage.convolve(img1, kernel_3 / np.max(kernel_3))
    _, thresh_img = cv2.threshold(filter_img, 300, 255,
                                  cv2.THRESH_BINARY)  # 图像的二值化  cv.THRESH_BINARY_INV+cv.THRESH_OTSU = 1+8=9
    dealed_img = cv2.dilate(thresh_img, kernel_21)  # 将一个源的光子簇合并为一个
    contours, hierarchy = cv2.findContours(dealed_img.astype(np.uint8), cv2.RETR_TREE, cv2.CHAIN_APPROX_NONE)
    xy_point = []
    contours = list(contours)
    for i, contour in enumerate(contours):
        # 删除边界点
        contour = np.reshape(contour, (-1, 2))
        n = len(contour)
        while n:
            n -= 1
            a = contour[n]
            if (0 in a) or ((s - 1) in a):
                contour = np.delete(contour, n, 0)
        contour = np.reshape(contour, (-1, 1, 2))
        contours[i] = contour  # 重新赋值！
        x, y, w, h = cv2.boundingRect(contour)  # contour是一个轮廓点集合
        if w != 0 and h != 0:
            if x <= 0 or y <= 0:
                print(x, y, w, h)
            elif x + w > s or y + h > s:
                print(x, y, w, h)
            else:
                xy_point.append((x, y, x + w, y + h))
    return xy_point
