# -*- coding: utf-8 -*-
# @Time : 2022/10/10 14:49
# @Author : lwb
# @File : GetXYCenter.py

import numpy as np

def get_xy_flux(det, img, flag):
    '''
    修正回归框的中心点和宽高！
    :param det:
    :param img:
    :return:
    '''
    # flux_thresh = 2
    x1 = det[:, 0].astype(np.int32)
    x2 = det[:, 2].astype(np.int32)
    y1 = det[:, 1].astype(np.int32)
    y2 = det[:, 3].astype(np.int32)
    flux_pre = []
    xy_point = []
    for i in range(len(det)):
        flux_pre.append(np.max(img[y1[i]:(y2[i] + 1), x1[i]:(x2[i] + 1)]))  # 将原图中框内最大的像素值作为flux值！
        index = np.argmax(img[y1[i]:(y2[i] + 1), x1[i]:(x2[i] + 1)])
        w = x2[i] - x1[i] + 1
        h = y2[i] - y1[i] + 1
        x0 = x1[i] + index % w
        y0 = y1[i] + index // w
        xy_point.append((x0, y0, w, h, flag))
    # # 保证分母不为0！
    # if np.min(flux_pre):
    #     _flux_pre = (1 / np.min(flux_pre)) * flux_pre * flux_thresh  # 保证_flux_pre值都大于2
    # else:
    #     raise Exception('min(flux_pre) is 0!')
    return xy_point, flux_pre