import pandas as pd
import numpy as np
import os

def cal_indicators_256and512(save_path, det, size):
    file_name = save_path.split("/")[-1].split("_")[0]
    csv_file = "../obsinfo/obsinfo" + file_name + '.csv'
    cmos = int(save_path.split("/")[-1].split(".")[0].split("_")[-1])
    df_label = pd.read_csv(csv_file)
    df_label_1 = df_label[(df_label['cmosnum'] == cmos)]  # .index.tolist()  # coms需要转成int
    df_label_1_x = df_label_1['x'].tolist()
    df_label_1_y = df_label_1['y'].tolist()
    n_real = len(df_label_1_y)  # 一张图像中需要检测到的总数目

    true_num = 0
    # 初始化指标
    offset = -7  # 检测结果的偏置！
    # 统计定位误差范围！
    # each_errr = []
    init_values = (16 * 2) ** 2
    # dic = {}
    flag = np.zeros(n_real)  # 标记已经检测到的目标位置
    # if det.any():  # 若是已经检测到目标
    if len(det):  # 若是已经检测到目标
        precision_num = len(det)
        for t in range(precision_num):  # 优先保存小图大目标的检测结果
            min_init_values = init_values  # 保存最小的距离
            # 保存检测框的图像
            for i in range(n_real):
                y0, x0 = df_label_1_y[i], df_label_1_x[i]  # 优先算作亮源！0-4095
                if det[t][4] == 0:
                    x_min = (det[t][0] - det[t][2] / 2) * (4096 / size)
                    x_max = (det[t][0] + det[t][2] / 2) * (4096 / size)
                    y_min = (det[t][1] - det[t][3] / 2) * (4096 / size)
                    y_max = (det[t][1] + det[t][3] / 2) * (4096 / size)
                    if (x0 <= x_max) and (x0 >= x_min) and (y0 <= y_max) and (y0 >= y_min):
                        # pdb.set_trace()
                        if not flag[i]:  # 防止重复保存，一个目标至多被检测到一次（不会出现多个框都检测到目标而计数的情况）
                            flag[i] = 1
                            # 另一种保存方法
                            # dic['%d:'%i] = ((xm1 + xm2) / 2, (ym1 + ym2) / 2)
                            true_num += 1
                            # print("true_num", true_num)
                            break  # 及时终止！一个框至多只算检测到一个目标，位置相近的目标可以用SOFT-NMS捕捉另外的框，或者调整阈值！)
                else:
                    radius_values = (x0 - det[t][0] * (4096 / size) + offset) ** 2 + (
                                y0 - det[t][1] * (4096 / size) + offset) ** 2
                    if radius_values < min_init_values:  # 可以调试再看-可以使用半径圆来判断！
                        if not flag[i]:  # 防止重复保存，一个目标至多被检测到一次（不会出现多个框都检测到目标而计数的情况）
                            flag[i] = 1
                            # 另一种保存方法
                            # dic['%d:'%i] = ((xm1 + xm2) / 2, (ym1 + ym2) / 2)
                            true_num += 1
                            break  # 及时终止！一个框至多只算检测到一个目标，位置相近的目标可以用SOFT-NMS捕捉另外的框，或者调整阈值！)
        # 计算查全\查准(合并重复的)\灵敏度
    # 计算查全\查准(合并重复的)\灵敏度
    return true_num

def cal_indicators(save_path, det, img_mat, flux_internal, real_target_folder, false_target_folder):
    file_name = save_path.split("/")[-1].split("_")[0]
    csv_file = "../obsinfo/obsinfo" + file_name + '.csv'
    cmos = save_path.split("/")[-1].split(".")[0].split("_")[-1]
    df_label = pd.read_csv(csv_file)
    df_label_1 = df_label[(df_label['cmosnum'] == int(cmos))]  # .index.tolist()  # coms需要转成int
    df_label_1_x = df_label_1['x'].tolist()
    df_label_1_y = df_label_1['y'].tolist()
    df_label_1_flux = df_label_1['flux/mCrab'].tolist()
    n_real = len(df_label_1_y)  # 一张图像中需要检测到的总数目

    # 初始化指标
    offset = -7  # 检测结果的偏置！
    pixel_scale = 0.1375  # 角分--原图的像素尺度
    init_values = (16 * 2) ** 2  # 设定真源范围阈值
    n_se_num = len(flux_internal)  # 总的区间数
    recall_internal_num = np.zeros(n_se_num)
    sensitivity_internal_num = np.zeros(n_se_num)
    err_internal_num = np.zeros(n_se_num)
    flag = np.zeros(n_real)  # 标记已经检测到的目标位置:前面已经有过筛选，若一次检测有重复目标，则都是真源！
    true_num = 0
    precision_num = len(det)  # 提高准确度表达的一个细节！
    # 统计定位误差范围！
    # each_errr = []
    # dic = {}
    file = open(save_path, 'w+')
    # if det.any():  # 若是已经检测到目标
    if precision_num:
        x1 = det[:, 0] - det[:, 2] // 2
        x2 = det[:, 0] + det[:, 2] // 2
        y1 = det[:, 1] - det[:, 3] // 2
        y2 = det[:, 1] + det[:, 3] // 2
        for t in range(precision_num):  # 优先保存小图大目标的检测结果
            # 保存检测框的图像
            for i in range(n_real):
                if not flag[i]:  # 防止重复保存，一个目标至多被检测到一次（不会出现多个框都检测到目标而计数的情况）
                    y0, x0 = df_label_1_y[i], df_label_1_x[i]  # 优先算作亮源！0-4095
                    radius_values = (x0 - det[t][0] + offset) ** 2 + (y0 - det[t][1] + offset) ** 2
                    if radius_values < init_values:  # 可以调试再看-可以使用半径圆来判断！
                        # 另一种保存方法
                        # dic['%d:'%i] = ((xm1 + xm2) / 2, (ym1 + ym2) / 2)
                        file.write("location {}(x,y,flux):{:.2f} {:.2f} {:.2f}\n".format(i + 1, det[t][0], det[t][1],
                                                                                         det[t][4]))
                        # 统计并保存真源
                        true_num += 1
                        real_target = img_mat[max(round(y1[t] / 8), 0): min(round(y2[t] / 8) + 1, 512),
                                      max(round(x1[t] / 8), 0):min(round(x2[t] / 8) + 1, 512)]
                        real_target_file = os.path.join(real_target_folder,
                                                        'real' + '_' + file_name + '_' + cmos + '_' + str(t) + '.npy')
                        np.save(real_target_file, real_target)

                        # 统计误差
                        err = (radius_values ** 0.5) * pixel_scale
                        # each_errr.append(err)  # 将距离最小的位置保存进来
                        if df_label_1_flux[i] >= flux_internal[-1]:
                            recall_internal_num[-1] += 1
                            err_internal_num[-1] += err
                        else:
                            for j in range(n_se_num - 1):
                                if df_label_1_flux[i] >= flux_internal[j] and df_label_1_flux[i] < flux_internal[j + 1]:
                                    recall_internal_num[j] += 1
                                    err_internal_num[j] += err
                        break  # 及时终止！一个框至多只算检测到一个目标，位置相近的目标可以用SOFT-NMS捕捉另外的框，或者调整阈值！)
            else:
                # 保存假源数据
                false_target = img_mat[max(round(y1[t] / 8), 0): min(round(y2[t] / 8) + 1, 512),
                               max(round(x1[t] / 8), 0):min(round(x2[t] / 8) + 1, 512)]
                false_target_file = os.path.join(false_target_folder,
                                                 'noise' + '_' + file_name + '_' + cmos + '_' + str(t) + '.npy')
                np.save(false_target_file, false_target)

    # 计算查全\查准(合并重复的)\灵敏度
    if not true_num:
        file.write("no detected object！\n")
        print("There is no detected object in the %s image of %s ！\n" % (cmos, file_name))
    for j in range(n_se_num - 1):
        sensitivity_internal_num[j] = len(list(
            filter(lambda t: t >= flux_internal[j] and t < flux_internal[j + 1],
                   df_label_1_flux)))  # 滤除小于sensitivity的数目！
    sensitivity_internal_num[-1] = len(
        list(filter(lambda t: t >= flux_internal[-1], df_label_1_flux)))  # 滤除小于sensitivity的数目！
    # 及时关闭文件
    file.close()

    return true_num, recall_internal_num, precision_num, sensitivity_internal_num, err_internal_num

# calculate pression and recall——比较简洁的方法
def cal_indicators_old(save_path, det, flux_internal):
    file_name = save_path.split("/")[-1].split("_")[0]
    csv_file = "../obsinfo/obsinfo" + file_name + '.csv'
    cmos = int(save_path.split("/")[-1].split(".")[0].split("_")[-1])
    df_label = pd.read_csv(csv_file)
    df_label_1 = df_label[(df_label['cmosnum'] == cmos)]  # .index.tolist()  # coms需要转成int
    df_label_1_x = df_label_1['x'].tolist()
    df_label_1_y = df_label_1['y'].tolist()
    df_label_1_flux = df_label_1['flux/mCrab'].tolist()
    n_real = len(df_label_1_y)  # 一张图像中需要检测到的总数目

    n_se_num = len(flux_internal)  # 总的区间数
    recall_internal_num = np.zeros(n_se_num)
    err_internal_num = np.zeros(n_se_num)
    sensitivity_internal_num = np.zeros(n_se_num)
    true_num = 0
    precision_num = 0  # 提高准确度表达的一个细节！
    # 初始化指标
    offset = -7  # 检测结果的偏置！
    pixel_scale = 0.1375
    # 统计定位误差范围！
    # each_errr = []
    init_values = (16 * 2) ** 2
    # dic = {}
    flag = np.zeros(n_real)  # 标记已经检测到的目标位置
    file = open(save_path, 'w+')
    # if det.any():  # 若是已经检测到目标
    if det:  # 若是已经检测到目标
        precision_num = len(det)
        for t in range(precision_num):  # 优先保存小图大目标的检测结果
            min_init_values = init_values  # 保存最小的距离
            # 保存检测框的图像
            for i in range(n_real):
                y0, x0 = df_label_1_y[i], df_label_1_x[i]  # 优先算作亮源！0-4095
                radius_values = (x0 - det[t][0] + offset) ** 2 + (y0 - det[t][1] + offset) ** 2
                if det[t][4] == 0:
                    # print(det[t])
                    # print(x0, y0)
                    # pdb.set_trace()
                    x_min = det[t][0] - det[t][2] / 2
                    x_max = det[t][0] + det[t][2] / 2
                    y_min = det[t][1] - det[t][3] / 2
                    y_max = det[t][1] + det[t][3] / 2
                    if (x0 <= x_max) and (x0 >= x_min) and (y0 <= y_max) and (y0 >= y_min):
                        if not flag[i]:  # 防止重复保存，一个目标至多被检测到一次（不会出现多个框都检测到目标而计数的情况）
                            flag[i] = 1
                            # 另一种保存方法
                            # dic['%d:'%i] = ((xm1 + xm2) / 2, (ym1 + ym2) / 2)
                            true_num += 1
                            err = (radius_values ** 0.5) * pixel_scale
                            # each_errr.append((radius_values ** 0.5) / 16)  # 将距离最小的位置保存进来
                            file.write(
                                "location {}(x,y,flux):{:.2f} {:.2f} {:.2f}\n".format(i + 1, det[t][0], det[t][1],
                                                                                      det[t][5]))
                            if df_label_1_flux[i] >= flux_internal[-1]:
                                recall_internal_num[-1] += 1
                                err_internal_num[-1] += err
                            else:
                                for j in range(n_se_num - 1):
                                    if df_label_1_flux[i] >= flux_internal[j] and df_label_1_flux[i] < flux_internal[j + 1]:
                                        recall_internal_num[j] += 1
                                        err_internal_num[j] += err
                            break  # 及时终止！一个框至多只算检测到一个目标，位置相近的目标可以用SOFT-NMS捕捉另外的框，或者调整阈值！)
                elif radius_values < min_init_values:  # 可以调试再看-可以使用半径圆来判断！
                    if not flag[i]:  # 防止重复保存，一个目标至多被检测到一次（不会出现多个框都检测到目标而计数的情况）
                        flag[i] = 1
                        # min_init_values = radius_values  # 更新最小的距离值！
                        # 另一种保存方法
                        # dic['%d:'%i] = ((xm1 + xm2) / 2, (ym1 + ym2) / 2)
                        true_num += 1
                        err = (radius_values ** 0.5) * pixel_scale
                        # each_errr.append((radius_values ** 0.5) / 16)  # 将距离最小的位置保存进来
                        file.write("location {}(x,y,flux):{:.2f} {:.2f} {:.2f}\n".format(i + 1, det[t][0], det[t][1],
                                                                                         det[t][5]))
                        if df_label_1_flux[i] >= flux_internal[-1]:
                            recall_internal_num[-1] += 1
                            err_internal_num[-1] += err
                        else:
                            for j in range(n_se_num - 1):
                                if df_label_1_flux[i] >= flux_internal[j] and df_label_1_flux[i] < flux_internal[j + 1]:
                                    recall_internal_num[j] += 1
                                    err_internal_num[j] += err
                        break  # 及时终止！一个框至多只算检测到一个目标，位置相近的目标可以用SOFT-NMS捕捉另外的框，或者调整阈值！)

        # 计算查全\查准(合并重复的)\灵敏度
    # 计算查全\查准(合并重复的)\灵敏度
    if not true_num:
        file.write("no detected object！\n")
        print("There is no detected object in the %d image of %s ！\n" % (cmos, file_name))
    for j in range(n_se_num - 1):
        sensitivity_internal_num[j] = len(list(
            filter(lambda t: t >= flux_internal[j] and t < flux_internal[j + 1],
                   df_label_1_flux)))  # 滤除小于sensitivity的数目！
    sensitivity_internal_num[-1] = len(
        list(filter(lambda t: t >= flux_internal[-1], df_label_1_flux)))  # 滤除小于sensitivity的数目！
    file.close()

    return true_num, recall_internal_num, precision_num, sensitivity_internal_num, err_internal_num

